/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHA256Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 32;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X = new int[64];
    private int xOff;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256Digest() {
        this.reset();
    }

    public SHA256Digest(SHA256Digest t2) {
        super(t2);
        this.copyIn(t2);
    }

    private void copyIn(SHA256Digest t2) {
        super.copyIn(t2);
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        this.H5 = t2.H5;
        this.H6 = t2.H6;
        this.H7 = t2.H7;
        this.H8 = t2.H8;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    public SHA256Digest(byte[] encodedState) {
        super(encodedState);
        this.H1 = Pack.bigEndianToInt(encodedState, 16);
        this.H2 = Pack.bigEndianToInt(encodedState, 20);
        this.H3 = Pack.bigEndianToInt(encodedState, 24);
        this.H4 = Pack.bigEndianToInt(encodedState, 28);
        this.H5 = Pack.bigEndianToInt(encodedState, 32);
        this.H6 = Pack.bigEndianToInt(encodedState, 36);
        this.H7 = Pack.bigEndianToInt(encodedState, 40);
        this.H8 = Pack.bigEndianToInt(encodedState, 44);
        this.xOff = Pack.bigEndianToInt(encodedState, 48);
        for (int i = 0; i != this.xOff; ++i) {
            this.X[i] = Pack.bigEndianToInt(encodedState, 52 + i * 4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.intToBigEndian(this.H1, out, outOff);
        Pack.intToBigEndian(this.H2, out, outOff + 4);
        Pack.intToBigEndian(this.H3, out, outOff + 8);
        Pack.intToBigEndian(this.H4, out, outOff + 12);
        Pack.intToBigEndian(this.H5, out, outOff + 16);
        Pack.intToBigEndian(this.H6, out, outOff + 20);
        Pack.intToBigEndian(this.H7, out, outOff + 24);
        Pack.intToBigEndian(this.H8, out, outOff + 28);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1779033703;
        this.H2 = -1150833019;
        this.H3 = 1013904242;
        this.H4 = -1521486534;
        this.H5 = 1359893119;
        this.H6 = -1694144372;
        this.H7 = 528734635;
        this.H8 = 1541459225;
        this.xOff = 0;
        for (int i = 0; i != this.X.length; ++i) {
            this.X[i] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int i;
        for (int t2 = 16; t2 <= 63; ++t2) {
            this.X[t2] = SHA256Digest.Theta1(this.X[t2 - 2]) + this.X[t2 - 7] + SHA256Digest.Theta0(this.X[t2 - 15]) + this.X[t2 - 16];
        }
        int a = this.H1;
        int b = this.H2;
        int c = this.H3;
        int d = this.H4;
        int e = this.H5;
        int f = this.H6;
        int g2 = this.H7;
        int h2 = this.H8;
        int t3 = 0;
        for (i = 0; i < 8; ++i) {
            d += (h2 += SHA256Digest.Sum1(e) + SHA256Digest.Ch(e, f, g2) + K[t3] + this.X[t3]);
            h2 += SHA256Digest.Sum0(a) + SHA256Digest.Maj(a, b, c);
            c += (g2 += SHA256Digest.Sum1(d) + SHA256Digest.Ch(d, e, f) + K[++t3] + this.X[t3]);
            g2 += SHA256Digest.Sum0(h2) + SHA256Digest.Maj(h2, a, b);
            b += (f += SHA256Digest.Sum1(c) + SHA256Digest.Ch(c, d, e) + K[++t3] + this.X[t3]);
            f += SHA256Digest.Sum0(g2) + SHA256Digest.Maj(g2, h2, a);
            a += (e += SHA256Digest.Sum1(b) + SHA256Digest.Ch(b, c, d) + K[++t3] + this.X[t3]);
            e += SHA256Digest.Sum0(f) + SHA256Digest.Maj(f, g2, h2);
            h2 += (d += SHA256Digest.Sum1(a) + SHA256Digest.Ch(a, b, c) + K[++t3] + this.X[t3]);
            d += SHA256Digest.Sum0(e) + SHA256Digest.Maj(e, f, g2);
            g2 += (c += SHA256Digest.Sum1(h2) + SHA256Digest.Ch(h2, a, b) + K[++t3] + this.X[t3]);
            c += SHA256Digest.Sum0(d) + SHA256Digest.Maj(d, e, f);
            f += (b += SHA256Digest.Sum1(g2) + SHA256Digest.Ch(g2, h2, a) + K[++t3] + this.X[t3]);
            b += SHA256Digest.Sum0(c) + SHA256Digest.Maj(c, d, e);
            e += (a += SHA256Digest.Sum1(f) + SHA256Digest.Ch(f, g2, h2) + K[++t3] + this.X[t3]);
            a += SHA256Digest.Sum0(b) + SHA256Digest.Maj(b, c, d);
            ++t3;
        }
        this.H1 += a;
        this.H2 += b;
        this.H3 += c;
        this.H4 += d;
        this.H5 += e;
        this.H6 += f;
        this.H7 += g2;
        this.H8 += h2;
        this.xOff = 0;
        for (i = 0; i < 16; ++i) {
            this.X[i] = 0;
        }
    }

    private static int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int Maj(int x, int y, int z) {
        return x & y | z & (x ^ y);
    }

    private static int Sum0(int x) {
        return (x >>> 2 | x << 30) ^ (x >>> 13 | x << 19) ^ (x >>> 22 | x << 10);
    }

    private static int Sum1(int x) {
        return (x >>> 6 | x << 26) ^ (x >>> 11 | x << 21) ^ (x >>> 25 | x << 7);
    }

    private static int Theta0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private static int Theta1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }

    @Override
    public Memoable copy() {
        return new SHA256Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA256Digest d = (SHA256Digest)other;
        this.copyIn(d);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] state = new byte[52 + this.xOff * 4];
        super.populateState(state);
        Pack.intToBigEndian(this.H1, state, 16);
        Pack.intToBigEndian(this.H2, state, 20);
        Pack.intToBigEndian(this.H3, state, 24);
        Pack.intToBigEndian(this.H4, state, 28);
        Pack.intToBigEndian(this.H5, state, 32);
        Pack.intToBigEndian(this.H6, state, 36);
        Pack.intToBigEndian(this.H7, state, 40);
        Pack.intToBigEndian(this.H8, state, 44);
        Pack.intToBigEndian(this.xOff, state, 48);
        for (int i = 0; i != this.xOff; ++i) {
            Pack.intToBigEndian(this.X[i], state, 52 + i * 4);
        }
        return state;
    }
}

