/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import org.bouncycastle.pqc.math.ntru.util.Util;

public class NTRUEncryptionKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUEncryptionKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUEncryptionKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DenseTernaryPolynomial g2;
        IntegerPolynomial fq;
        Polynomial t2;
        int N2 = this.params.N;
        int q = this.params.q;
        int df = this.params.df;
        int df1 = this.params.df1;
        int df2 = this.params.df2;
        int df3 = this.params.df3;
        int dg = this.params.dg;
        boolean fastFp = this.params.fastFp;
        boolean sparse = this.params.sparse;
        IntegerPolynomial fp = null;
        while (true) {
            IntegerPolynomial f;
            if (fastFp) {
                t2 = this.params.polyType == 0 ? Util.generateRandomTernary(N2, df, df, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N2, df1, df2, df3, df3, this.params.getRandom());
                f = t2.toIntegerPolynomial();
                f.mult(3);
                f.coeffs[0] = f.coeffs[0] + 1;
            } else {
                t2 = this.params.polyType == 0 ? Util.generateRandomTernary(N2, df, df - 1, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N2, df1, df2, df3, df3 - 1, this.params.getRandom());
                f = t2.toIntegerPolynomial();
                fp = f.invertF3();
                if (fp == null) continue;
            }
            if ((fq = f.invertFq(q)) != null) break;
        }
        if (fastFp) {
            fp = new IntegerPolynomial(N2);
            fp.coeffs[0] = 1;
        }
        while ((g2 = DenseTernaryPolynomial.generateRandom(N2, dg, dg - 1, this.params.getRandom())).invertFq(q) == null) {
        }
        IntegerPolynomial h2 = g2.mult(fq, q);
        h2.mult3(q);
        h2.ensurePositive(q);
        g2.clear();
        fq.clear();
        NTRUEncryptionPrivateKeyParameters priv = new NTRUEncryptionPrivateKeyParameters(h2, t2, fp, this.params.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters pub = new NTRUEncryptionPublicKeyParameters(h2, this.params.getEncryptionParameters());
        return new AsymmetricCipherKeyPair(pub, priv);
    }
}

