/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceCCA2KeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final String SHA1 = "SHA-1";
    public static final String SHA224 = "SHA-224";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private final int m;
    private final int t;
    private final int n;
    private int fieldPoly;
    private final String digest;

    public McElieceCCA2KeyGenParameterSpec() {
        this(11, 50, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int keysize) {
        this(keysize, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int keysize, String digest) {
        if (keysize < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        int m4 = 0;
        int n = 1;
        while (n < keysize) {
            n <<= 1;
            ++m4;
        }
        this.t = (n >>> 1) / m4;
        this.m = m4;
        this.n = n;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(m4);
        this.digest = digest;
    }

    public McElieceCCA2KeyGenParameterSpec(int m4, int t2) {
        this(m4, t2, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int m4, int t2, String digest) {
        if (m4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m4 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.m = m4;
        this.n = 1 << m4;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.t = t2;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(m4);
        this.digest = digest;
    }

    public McElieceCCA2KeyGenParameterSpec(int m4, int t2, int poly) {
        this(m4, t2, poly, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int m4, int t2, int poly, String digest) {
        this.m = m4;
        if (m4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m4 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.n = 1 << m4;
        this.t = t2;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(poly) != m4 || !PolynomialRingGF2.isIrreducible(poly)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.fieldPoly = poly;
        this.digest = digest;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }

    public String getDigest() {
        return this.digest;
    }
}

