/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru.polynomial;

import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import org.bouncycastle.util.Arrays;

public class LongPolynomial5 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial5(IntegerPolynomial p) {
        this.numCoeffs = p.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 4) / 5];
        int cIdx = 0;
        int shift = 0;
        for (int i = 0; i < this.numCoeffs; ++i) {
            int n = cIdx++;
            this.coeffs[n] = this.coeffs[n] | (long)p.coeffs[i] << shift;
            if ((shift += 12) < 60) continue;
            shift = 0;
        }
    }

    private LongPolynomial5(long[] coeffs, int numCoeffs) {
        this.coeffs = coeffs;
        this.numCoeffs = numCoeffs;
    }

    public LongPolynomial5 mult(TernaryPolynomial poly2) {
        int cIdx;
        long[][] prod = new long[5][this.coeffs.length + (poly2.size() + 4) / 5 - 1];
        int[] ones = poly2.getOnes();
        for (int idx = 0; idx != ones.length; ++idx) {
            int pIdx = ones[idx];
            int cIdx2 = pIdx / 5;
            int m4 = pIdx - cIdx2 * 5;
            for (int i = 0; i < this.coeffs.length; ++i) {
                prod[m4][cIdx2] = prod[m4][cIdx2] + this.coeffs[i] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx2;
            }
        }
        int[] negOnes = poly2.getNegOnes();
        for (int idx = 0; idx != negOnes.length; ++idx) {
            int pIdx = negOnes[idx];
            cIdx = pIdx / 5;
            int m5 = pIdx - cIdx * 5;
            for (int i = 0; i < this.coeffs.length; ++i) {
                prod[m5][cIdx] = 0x800800800800800L + prod[m5][cIdx] - this.coeffs[i] & 0x7FF7FF7FF7FF7FFL;
                ++cIdx;
            }
        }
        long[] cCoeffs = Arrays.copyOf(prod[0], prod[0].length + 1);
        for (int m6 = 1; m6 <= 4; ++m6) {
            int shift = m6 * 12;
            int shift60 = 60 - shift;
            long mask = (1L << shift60) - 1L;
            int pLen = prod[m6].length;
            for (int i = 0; i < pLen; ++i) {
                long upper = prod[m6][i] >> shift60;
                long lower = prod[m6][i] & mask;
                cCoeffs[i] = cCoeffs[i] + (lower << shift) & 0x7FF7FF7FF7FF7FFL;
                int nextIdx = i + 1;
                cCoeffs[nextIdx] = cCoeffs[nextIdx] + upper & 0x7FF7FF7FF7FF7FFL;
            }
        }
        int shift = 12 * (this.numCoeffs % 5);
        for (cIdx = this.coeffs.length - 1; cIdx < cCoeffs.length; ++cIdx) {
            int newIdx;
            long iCoeff;
            if (cIdx == this.coeffs.length - 1) {
                iCoeff = this.numCoeffs == 5 ? 0L : cCoeffs[cIdx] >> shift;
                newIdx = 0;
            } else {
                iCoeff = cCoeffs[cIdx];
                newIdx = cIdx * 5 - this.numCoeffs;
            }
            int base = newIdx / 5;
            int m7 = newIdx - base * 5;
            long lower = iCoeff << 12 * m7;
            long upper = iCoeff >> 12 * (5 - m7);
            cCoeffs[base] = cCoeffs[base] + lower & 0x7FF7FF7FF7FF7FFL;
            int base1 = base + 1;
            if (base1 >= this.coeffs.length) continue;
            cCoeffs[base1] = cCoeffs[base1] + upper & 0x7FF7FF7FF7FF7FFL;
        }
        return new LongPolynomial5(cCoeffs, this.numCoeffs);
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int cIdx = 0;
        int shift = 0;
        for (int i = 0; i < this.numCoeffs; ++i) {
            intCoeffs[i] = (int)(this.coeffs[cIdx] >> shift & 0x7FFL);
            if ((shift += 12) < 60) continue;
            shift = 0;
            ++cIdx;
        }
        return new IntegerPolynomial(intCoeffs);
    }
}

