/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.android.vending.developer.signing.tools.extern.export;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.security.keymaster.lite.KeymaestroHybridEncrypter;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreHelper;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreKey;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.UnsupportedAlgorithmException;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.engines.AESWrapPadEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class ExportEncryptedPrivateKeyTool {
    private static final String FLAG_KEYSTORE = "keystore";
    private static final String FLAG_ALIAS = "alias";
    private static final String FLAG_RSA_AES_ENCRYPTION = "rsa-aes-encryption";
    private static final String FLAG_ENCRYPTION_KEY_PATH = "encryption-key-path";
    private static final String FLAG_ENCRYPTION_KEY = "encryptionkey";
    private static final String FLAG_OUTPUT = "output";
    private static final String FLAG_SIGNING_KEYSTORE = "signing-keystore";
    private static final String FLAG_SIGNING_KEY_ALIAS = "signing-key-alias";
    private static final String FLAG_KEYSTORE_PWD = "keystore-pass";
    private static final String FLAG_KEY_PWD = "key-pass";
    private static final String FLAG_INCLUDE_CERT = "include-cert";
    private static final ImmutableList<String> SUPPORTED_SIGNING_ALGORITHMS = ImmutableList.of("RSA", "DSA");
    private static final String HELP_PAGE = "help.txt";
    private static final String LICENSE_PAGE = "license.txt";
    private final KeystoreHelper keystoreHelper;

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        if (args.length == 0 || args[0].equals("--help")) {
            ExportEncryptedPrivateKeyTool.printUsage();
            return;
        }
        if (args[0].equals("--license")) {
            ExportEncryptedPrivateKeyTool.printLicense();
            return;
        }
        boolean useRsaAesEncryption = false;
        String keystoreFile = null;
        String alias = null;
        String rsaAesEncryption = null;
        String encryptionPublicKey = null;
        String outputFile = null;
        String signingKeyAlias = null;
        String signingKeystoreFile = null;
        String keystorePassword = null;
        String keyPassword = null;
        String includeCert = null;
        try {
            Map<String, String> parsedFlags = Utils.processArgs(args);
            keystoreFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEYSTORE);
            alias = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ALIAS);
            outputFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_OUTPUT);
            if (parsedFlags.containsKey(FLAG_RSA_AES_ENCRYPTION)) {
                rsaAesEncryption = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_RSA_AES_ENCRYPTION);
            }
            encryptionPublicKey = (useRsaAesEncryption = Boolean.parseBoolean(rsaAesEncryption)) ? ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ENCRYPTION_KEY_PATH) : ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ENCRYPTION_KEY);
            if (parsedFlags.containsKey(FLAG_SIGNING_KEY_ALIAS)) {
                signingKeyAlias = parsedFlags.remove(FLAG_SIGNING_KEY_ALIAS);
                signingKeystoreFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_SIGNING_KEYSTORE);
            } else if (parsedFlags.containsKey(FLAG_INCLUDE_CERT)) {
                includeCert = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_INCLUDE_CERT);
            }
            if (parsedFlags.containsKey(FLAG_KEYSTORE_PWD)) {
                keystorePassword = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEYSTORE_PWD);
            }
            if (parsedFlags.containsKey(FLAG_KEY_PWD)) {
                keyPassword = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEY_PWD);
            }
            if (keyPassword == null) {
                keyPassword = keystorePassword;
            }
            if (!parsedFlags.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized flags: " + String.valueOf(parsedFlags));
            }
        }
        catch (RuntimeException e) {
            System.err.println("Error: Unable to parse the input: " + Arrays.toString(args));
            e.printStackTrace();
            ExportEncryptedPrivateKeyTool.printUsage();
            System.exit(1);
        }
        try {
            ExportEncryptedPrivateKeyTool tool = new ExportEncryptedPrivateKeyTool(new KeystoreHelper());
            KeystoreKey keyToExport = keystorePassword != null && keyPassword != null ? new KeystoreKey(Paths.get(keystoreFile, new String[0]), alias, keystorePassword.toCharArray(), keyPassword.toCharArray()) : new KeystoreKey(Paths.get(keystoreFile, new String[0]), alias);
            Optional<KeystoreKey> keyToSignWith = signingKeystoreFile != null && signingKeyAlias != null ? Optional.of(new KeystoreKey(Paths.get(signingKeystoreFile, new String[0]), signingKeyAlias)) : Optional.empty();
            boolean includeCertificate = Boolean.parseBoolean(includeCert);
            tool.run(useRsaAesEncryption, encryptionPublicKey, outputFile, keyToExport, keyToSignWith, includeCertificate);
        }
        catch (Exception e) {
            System.err.println("Error: Unable to export or encrypt the private key");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String getFlagValue(Map<String, String> parsedFlags, String flagName) {
        return Utils.checkNotNull(parsedFlags.remove(flagName), "--" + flagName + " must be specified");
    }

    ExportEncryptedPrivateKeyTool(KeystoreHelper keystoreHelper) {
        this.keystoreHelper = keystoreHelper;
    }

    public ExportEncryptedPrivateKeyTool() {
        this.keystoreHelper = new KeystoreHelper();
    }

    public void run(boolean useRsaAesEncryption, String encryptionPublicKey, String outputFile, KeystoreKey keyToExport, Optional<KeystoreKey> keyToSignWith, boolean includeCertificate) throws Exception {
        KeyStore keyStoreForKeyToExport = this.keystoreHelper.getKeystore(keyToExport);
        PrivateKey privateKeyToExport = this.keystoreHelper.getPrivateKey(keyStoreForKeyToExport, keyToExport);
        byte[] encryptedPrivateKey = useRsaAesEncryption ? this.encryptPrivateKeyWithCkmRsaAesKeyWrapEncryption(Files.readAllBytes(Paths.get(encryptionPublicKey, new String[0])), privateKeyToExport) : this.encryptPrivateKeyWithEcP256AesGcmHybridEncryption(ExportEncryptedPrivateKeyTool.fromHex(encryptionPublicKey), privateKeyToExport);
        if (keyToSignWith.isPresent() || includeCertificate) {
            Certificate certificate = this.keystoreHelper.getCertificate(keyStoreForKeyToExport, keyToExport);
            Optional<byte[]> signature = keyToSignWith.isPresent() ? Optional.of(this.sign(encryptedPrivateKey, keyToSignWith.get())) : Optional.empty();
            this.writeToZipFile(outputFile, signature, encryptedPrivateKey, ExportEncryptedPrivateKeyTool.certificateToPem(certificate));
        } else {
            Files.write(Paths.get(outputFile, new String[0]), encryptedPrivateKey, new OpenOption[0]);
        }
    }

    public byte[] sign(byte[] payload, KeystoreKey signingKey) throws Exception {
        KeyStore keyStoreOfSigningKey = this.keystoreHelper.getKeystore(signingKey);
        PrivateKey pk = this.keystoreHelper.getPrivateKey(keyStoreOfSigningKey, signingKey);
        if (!SUPPORTED_SIGNING_ALGORITHMS.contains(pk.getAlgorithm())) {
            throw new UnsupportedAlgorithmException(String.format("The signing key uses an unsupported algorithm. The tool only supports %s .", SUPPORTED_SIGNING_ALGORITHMS));
        }
        Signature sig = Signature.getInstance("SHA512with" + pk.getAlgorithm());
        sig.initSign(pk);
        sig.update(payload);
        return sig.sign();
    }

    static byte[] privateKeyToPem(PrivateKey privateKey) {
        String pemString = "-----BEGIN PRIVATE KEY-----\n" + ExportEncryptedPrivateKeyTool.formatBase64String(Base64.getEncoder().encodeToString(privateKey.getEncoded())) + "\n-----END PRIVATE KEY-----\n";
        return pemString.getBytes(StandardCharsets.US_ASCII);
    }

    private static byte[] certificateToPem(Certificate certificate) throws CertificateEncodingException {
        return ("-----BEGIN CERTIFICATE-----\n" + ExportEncryptedPrivateKeyTool.formatBase64String(Base64.getEncoder().encodeToString(certificate.getEncoded())) + "\n-----END CERTIFICATE-----\n").getBytes(StandardCharsets.US_ASCII);
    }

    static String formatBase64String(String string) {
        return String.join((CharSequence)"\n", Splitter.fixedLength(64).splitToList(string));
    }

    private byte[] encryptPrivateKeyWithEcP256AesGcmHybridEncryption(byte[] encryptionPublicKey, PrivateKey privateKey) throws GeneralSecurityException {
        byte[] privateKeyPem = ExportEncryptedPrivateKeyTool.privateKeyToPem(privateKey);
        return new KeymaestroHybridEncrypter(encryptionPublicKey).encrypt(privateKeyPem);
    }

    private byte[] encryptPrivateKeyWithCkmRsaAesKeyWrapEncryption(byte[] encryptionPublicKey, PrivateKey privateKey) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey randomAesKey = keyGenerator.generateKey();
        PublicKey publicKey = this.readPublicKey(encryptionPublicKey);
        Cipher rsaesOaepCipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
        rsaesOaepCipher.init(1, publicKey);
        byte[] encryptedAesKey = rsaesOaepCipher.doFinal(randomAesKey.getEncoded());
        AESWrapPadEngine aesWrapPadEngine = new AESWrapPadEngine();
        aesWrapPadEngine.init(true, new KeyParameter(randomAesKey.getEncoded()));
        byte[] privateKeyBytes = privateKey.getEncoded();
        byte[] encryptedPrivateKey = aesWrapPadEngine.wrap(privateKeyBytes, 0, privateKeyBytes.length);
        return ByteBuffer.allocate(encryptedAesKey.length + encryptedPrivateKey.length).put(encryptedAesKey).put(encryptedPrivateKey).array();
    }

    private PublicKey readPublicKey(byte[] pemPublicKey) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        try (InputStreamReader keyReader = new InputStreamReader((InputStream)new ByteArrayInputStream(pemPublicKey), StandardCharsets.UTF_8);){
            PublicKey publicKey;
            try (PemReader pemReader = new PemReader(keyReader);){
                PemObject pemObject = pemReader.readPemObject();
                byte[] content = pemObject.getContent();
                X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
                publicKey = factory.generatePublic(pubKeySpec);
            }
            return publicKey;
        }
    }

    private void writeToZipFile(String outputFile, Optional<byte[]> signature, byte[] encryptedPrivateKey, byte[] pemEncodedCertificate) throws Exception {
        Path tempFile = Files.createFile(Paths.get(outputFile, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile.toString()));){
            if (signature.isPresent()) {
                zipOutputStream.putNextEntry(new ZipEntry("encryptedPrivateKeySignature"));
                zipOutputStream.write(signature.get());
            }
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("encryptedPrivateKey"));
            zipOutputStream.write(encryptedPrivateKey);
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("certificate.pem"));
            zipOutputStream.write(pemEncodedCertificate);
            zipOutputStream.closeEntry();
        }
    }

    private static byte[] fromHex(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Hex encoded byte array must have even length but instead has length: " + len + ". Hex encoded string: " + s2);
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s2.charAt(i), 16) << 4) + Character.digit(s2.charAt(i + 1), 16));
        }
        return data;
    }

    private static void printUsage() {
        ExportEncryptedPrivateKeyTool.printFile(HELP_PAGE);
    }

    private static void printLicense() {
        ExportEncryptedPrivateKeyTool.printFile(LICENSE_PAGE);
    }

    private static void printFile(String fileName) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ExportEncryptedPrivateKeyTool.class.getResourceAsStream(fileName), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + fileName + " resource");
        }
    }
}

