/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.ocsp;

import java.io.OutputStream;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.operator.DigestCalculator;

public class RespID {
    public static final AlgorithmIdentifier HASH_SHA1 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Name name) {
        this.id = new ResponderID(name);
    }

    public RespID(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestCalculator digCalc) throws OCSPException {
        try {
            if (!digCalc.getAlgorithmIdentifier().equals(HASH_SHA1)) {
                throw new IllegalArgumentException("only SHA-1 can be used with RespID - found: " + String.valueOf(digCalc.getAlgorithmIdentifier().getAlgorithm()));
            }
            OutputStream digOut = digCalc.getOutputStream();
            digOut.write(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            digOut.close();
            this.id = new ResponderID(new DEROctetString(digCalc.getDigest()));
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + String.valueOf(e), e);
        }
    }

    public ResponderID toASN1Primitive() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

