/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

public class Interleave {
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;
    private static final long M64R = -6148914691236517206L;

    public static int expand8to16(int x) {
        x &= 0xFF;
        x = (x | x << 4) & 0xF0F;
        x = (x | x << 2) & 0x3333;
        x = (x | x << 1) & 0x5555;
        return x;
    }

    public static int expand16to32(int x) {
        x &= 0xFFFF;
        x = (x | x << 8) & 0xFF00FF;
        x = (x | x << 4) & 0xF0F0F0F;
        x = (x | x << 2) & 0x33333333;
        x = (x | x << 1) & 0x55555555;
        return x;
    }

    public static long expand32to64(int x) {
        int t2 = (x ^ x >>> 8) & 0xFF00;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F0;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 1) & 0x22222222;
        return ((long)((x ^= t2 ^ t2 << 1) >>> 1) & 0x55555555L) << 32 | (long)x & 0x55555555L;
    }

    public static void expand64To128(long x, long[] z, int zOff) {
        long t2 = (x ^ x >>> 16) & 0xFFFF0000L;
        x ^= t2 ^ t2 << 16;
        t2 = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 1) & 0x2222222222222222L;
        z[zOff] = (x ^= t2 ^ t2 << 1) & 0x5555555555555555L;
        z[zOff + 1] = x >>> 1 & 0x5555555555555555L;
    }

    public static void expand64To128Rev(long x, long[] z, int zOff) {
        long t2 = (x ^ x >>> 16) & 0xFFFF0000L;
        x ^= t2 ^ t2 << 16;
        t2 = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 1) & 0x2222222222222222L;
        z[zOff] = (x ^= t2 ^ t2 << 1) & 0xAAAAAAAAAAAAAAAAL;
        z[zOff + 1] = x << 1 & 0xAAAAAAAAAAAAAAAAL;
    }

    public static int shuffle(int x) {
        int t2 = (x ^ x >>> 8) & 0xFF00;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F0;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 1) & 0x22222222;
        return x ^= t2 ^ t2 << 1;
    }

    public static long shuffle(long x) {
        long t2 = (x ^ x >>> 16) & 0xFFFF0000L;
        x ^= t2 ^ t2 << 16;
        t2 = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 1) & 0x2222222222222222L;
        return x ^= t2 ^ t2 << 1;
    }

    public static int shuffle2(int x) {
        int t2 = (x ^ x >>> 7) & 0xAA00AA;
        x ^= t2 ^ t2 << 7;
        t2 = (x ^ x >>> 14) & 0xCCCC;
        x ^= t2 ^ t2 << 14;
        t2 = (x ^ x >>> 4) & 0xF000F0;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 8) & 0xFF00;
        return x ^= t2 ^ t2 << 8;
    }

    public static int unshuffle(int x) {
        int t2 = (x ^ x >>> 1) & 0x22222222;
        x ^= t2 ^ t2 << 1;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 4) & 0xF000F0;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 8) & 0xFF00;
        return x ^= t2 ^ t2 << 8;
    }

    public static long unshuffle(long x) {
        long t2 = (x ^ x >>> 1) & 0x2222222222222222L;
        x ^= t2 ^ t2 << 1;
        t2 = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t2 ^ t2 << 2;
        t2 = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 16) & 0xFFFF0000L;
        return x ^= t2 ^ t2 << 16;
    }

    public static int unshuffle2(int x) {
        int t2 = (x ^ x >>> 8) & 0xFF00;
        x ^= t2 ^ t2 << 8;
        t2 = (x ^ x >>> 4) & 0xF000F0;
        x ^= t2 ^ t2 << 4;
        t2 = (x ^ x >>> 14) & 0xCCCC;
        x ^= t2 ^ t2 << 14;
        t2 = (x ^ x >>> 7) & 0xAA00AA;
        return x ^= t2 ^ t2 << 7;
    }
}

