/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public class GF2nPolynomial {
    private GF2nElement[] coeff;
    private int size;

    public GF2nPolynomial(int deg, GF2nElement elem) {
        this.size = deg;
        this.coeff = new GF2nElement[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.coeff[i] = (GF2nElement)elem.clone();
        }
    }

    private GF2nPolynomial(int deg) {
        this.size = deg;
        this.coeff = new GF2nElement[this.size];
    }

    public GF2nPolynomial(GF2nPolynomial a) {
        this.coeff = new GF2nElement[a.size];
        this.size = a.size;
        for (int i = 0; i < this.size; ++i) {
            this.coeff[i] = (GF2nElement)a.coeff[i].clone();
        }
    }

    public GF2nPolynomial(GF2Polynomial polynomial, GF2nField B1) {
        this.size = B1.getDegree() + 1;
        this.coeff = new GF2nElement[this.size];
        if (B1 instanceof GF2nONBField) {
            for (int i = 0; i < this.size; ++i) {
                this.coeff[i] = polynomial.testBit(i) ? GF2nONBElement.ONE((GF2nONBField)B1) : GF2nONBElement.ZERO((GF2nONBField)B1);
            }
        } else if (B1 instanceof GF2nPolynomialField) {
            for (int i = 0; i < this.size; ++i) {
                this.coeff[i] = polynomial.testBit(i) ? GF2nPolynomialElement.ONE((GF2nPolynomialField)B1) : GF2nPolynomialElement.ZERO((GF2nPolynomialField)B1);
            }
        } else {
            throw new IllegalArgumentException("PolynomialGF2n(Bitstring, GF2nField): B1 must be an instance of GF2nONBField or GF2nPolynomialField!");
        }
    }

    public final void assignZeroToElements() {
        for (int i = 0; i < this.size; ++i) {
            this.coeff[i].assignZero();
        }
    }

    public final int size() {
        return this.size;
    }

    public final int getDegree() {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.coeff[i].isZero()) continue;
            return i;
        }
        return -1;
    }

    public final void enlarge(int k) {
        if (k <= this.size) {
            return;
        }
        GF2nElement[] res = new GF2nElement[k];
        System.arraycopy(this.coeff, 0, res, 0, this.size);
        GF2nField f = this.coeff[0].getField();
        if (this.coeff[0] instanceof GF2nPolynomialElement) {
            for (int i = this.size; i < k; ++i) {
                res[i] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)f);
            }
        } else if (this.coeff[0] instanceof GF2nONBElement) {
            for (int i = this.size; i < k; ++i) {
                res[i] = GF2nONBElement.ZERO((GF2nONBField)f);
            }
        }
        this.size = k;
        this.coeff = res;
    }

    public final void shrink() {
        int i;
        for (i = this.size - 1; this.coeff[i].isZero() && i > 0; --i) {
        }
        if (++i < this.size) {
            GF2nElement[] res = new GF2nElement[i];
            System.arraycopy(this.coeff, 0, res, 0, i);
            this.coeff = res;
            this.size = i;
        }
    }

    public final void set(int index, GF2nElement elem) {
        if (!(elem instanceof GF2nPolynomialElement) && !(elem instanceof GF2nONBElement)) {
            throw new IllegalArgumentException("PolynomialGF2n.set f must be an instance of either GF2nPolynomialElement or GF2nONBElement!");
        }
        this.coeff[index] = (GF2nElement)elem.clone();
    }

    public final GF2nElement at(int index) {
        return this.coeff[index];
    }

    public final boolean isZero() {
        for (int i = 0; i < this.size; ++i) {
            if (this.coeff[i] == null || this.coeff[i].isZero()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomial)) {
            return false;
        }
        GF2nPolynomial otherPol = (GF2nPolynomial)other;
        if (this.getDegree() != otherPol.getDegree()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.coeff[i].equals(otherPol.coeff[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getDegree() + this.coeff.hashCode();
    }

    public final GF2nPolynomial add(GF2nPolynomial b) {
        GF2nPolynomial result;
        if (this.size() >= b.size()) {
            int i;
            result = new GF2nPolynomial(this.size());
            for (i = 0; i < b.size(); ++i) {
                result.coeff[i] = (GF2nElement)this.coeff[i].add(b.coeff[i]);
            }
            while (i < this.size()) {
                result.coeff[i] = this.coeff[i];
                ++i;
            }
        } else {
            int i;
            result = new GF2nPolynomial(b.size());
            for (i = 0; i < this.size(); ++i) {
                result.coeff[i] = (GF2nElement)this.coeff[i].add(b.coeff[i]);
            }
            while (i < b.size()) {
                result.coeff[i] = b.coeff[i];
                ++i;
            }
        }
        return result;
    }

    public final GF2nPolynomial scalarMultiply(GF2nElement s2) {
        GF2nPolynomial result = new GF2nPolynomial(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.coeff[i] = (GF2nElement)this.coeff[i].multiply(s2);
        }
        return result;
    }

    public final GF2nPolynomial multiply(GF2nPolynomial b) {
        int bDegree;
        int aDegree = this.size();
        if (aDegree != (bDegree = b.size())) {
            throw new IllegalArgumentException("PolynomialGF2n.multiply: this and b must have the same size!");
        }
        GF2nPolynomial result = new GF2nPolynomial((aDegree << 1) - 1);
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < b.size(); ++j) {
                result.coeff[i + j] = result.coeff[i + j] == null ? (GF2nElement)this.coeff[i].multiply(b.coeff[j]) : (GF2nElement)result.coeff[i + j].add(this.coeff[i].multiply(b.coeff[j]));
            }
        }
        return result;
    }

    public final GF2nPolynomial multiplyAndReduce(GF2nPolynomial b, GF2nPolynomial g2) {
        return this.multiply(b).reduce(g2);
    }

    public final GF2nPolynomial reduce(GF2nPolynomial g2) throws RuntimeException, ArithmeticException {
        return this.remainder(g2);
    }

    public final void shiftThisLeft(int amount) {
        block3: {
            int i;
            GF2nField f;
            block4: {
                if (amount <= 0) break block3;
                int oldSize = this.size;
                f = this.coeff[0].getField();
                this.enlarge(this.size + amount);
                for (i = oldSize - 1; i >= 0; --i) {
                    this.coeff[i + amount] = this.coeff[i];
                }
                if (!(this.coeff[0] instanceof GF2nPolynomialElement)) break block4;
                for (i = amount - 1; i >= 0; --i) {
                    this.coeff[i] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)f);
                }
                break block3;
            }
            if (!(this.coeff[0] instanceof GF2nONBElement)) break block3;
            for (i = amount - 1; i >= 0; --i) {
                this.coeff[i] = GF2nONBElement.ZERO((GF2nONBField)f);
            }
        }
    }

    public final GF2nPolynomial shiftLeft(int amount) {
        if (amount <= 0) {
            return new GF2nPolynomial(this);
        }
        GF2nPolynomial result = new GF2nPolynomial(this.size + amount, this.coeff[0]);
        result.assignZeroToElements();
        for (int i = 0; i < this.size; ++i) {
            result.coeff[i + amount] = this.coeff[i];
        }
        return result;
    }

    public final GF2nPolynomial[] divide(GF2nPolynomial b) {
        GF2nPolynomial[] result = new GF2nPolynomial[2];
        GF2nPolynomial a = new GF2nPolynomial(this);
        a.shrink();
        int bDegree = b.getDegree();
        GF2nElement inv = (GF2nElement)b.coeff[bDegree].invert();
        if (a.getDegree() < bDegree) {
            result[0] = new GF2nPolynomial(this);
            result[0].assignZeroToElements();
            result[0].shrink();
            result[1] = new GF2nPolynomial(this);
            result[1].shrink();
            return result;
        }
        result[0] = new GF2nPolynomial(this);
        result[0].assignZeroToElements();
        int i = a.getDegree() - bDegree;
        while (i >= 0) {
            GF2nElement factor = (GF2nElement)a.coeff[a.getDegree()].multiply(inv);
            GF2nPolynomial shift = b.scalarMultiply(factor);
            shift.shiftThisLeft(i);
            a = a.add(shift);
            a.shrink();
            result[0].coeff[i] = (GF2nElement)factor.clone();
            i = a.getDegree() - bDegree;
        }
        result[1] = a;
        result[0].shrink();
        return result;
    }

    public final GF2nPolynomial remainder(GF2nPolynomial b) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] result = new GF2nPolynomial[2];
        result = this.divide(b);
        return result[1];
    }

    public final GF2nPolynomial quotient(GF2nPolynomial b) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] result = new GF2nPolynomial[2];
        result = this.divide(b);
        return result[0];
    }

    public final GF2nPolynomial gcd(GF2nPolynomial g2) {
        GF2nPolynomial a = new GF2nPolynomial(this);
        GF2nPolynomial b = new GF2nPolynomial(g2);
        a.shrink();
        b.shrink();
        while (!b.isZero()) {
            GF2nPolynomial c = a.remainder(b);
            a = b;
            b = c;
        }
        GF2nElement alpha = a.coeff[a.getDegree()];
        GF2nPolynomial result = a.scalarMultiply((GF2nElement)alpha.invert());
        return result;
    }
}

